﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.BusinessAHOBPR.VeteranStatusService;


namespace VeteransAffairs.Registries.BusinessManagerAHOBPR.Emis
{
    public class VeteranStatusImporter : AHOBPRBaseBO
    {

        eMISVeteranStatusServicePortTypesClient _client;
        InputHeaderInfo _inputHeaderInfo;
        public VeteranStatusImporter()
        {
            _client = new eMISVeteranStatusServicePortTypesClient();
            _inputHeaderInfo = new InputHeaderInfo();
        }  
        public VeteranStatus GetVeteranStatus(string edipi)
        {

            var inputEdipiIcn = CreateEdipi(edipi);
            eMISveteranStatusResponseType response = GetVeteranStatusResponse(inputEdipiIcn, _inputHeaderInfo);
            if (response.ESSError != null)
            {
                Trace.WriteLine("ESSError retreiving response from eMIS. VeteranStatusImporter.GetVeteranStatus: " + response.ESSError.text);
                AHOBPRLogger.LogErrorMessage("ESSERROR calling GetVeteranStatus", this.GetType().Name + "." + System.Reflection.MethodBase.GetCurrentMethod().Name, response.ESSError.text);
            }
            return response.veteranStatus;
        }
        private inputEdiPiOrIcn CreateEdipi(string edipi)
        {
            var builder = new InputEdipiIcn();
            builder.edipiORicnValue = edipi;
            builder.inputType = InputEdipiIcnInputType.EDIPI;
            var output = new inputEdiPiOrIcn();
            output.edipiORicn = builder;
            return output;
        }
        private eMISveteranStatusResponseType GetVeteranStatusResponse(inputEdiPiOrIcn edipi, InputHeaderInfo inputHeaderInfo)
        {
            eMISveteranStatusResponseType response = null;
            try
            {
                response = _client.getVeteranStatus(ref inputHeaderInfo, edipi);
            }
            catch (Exception ex)
            {
                Trace.WriteLine("Exception: VeteranStatusImporter.GetVeteranStatusResponse: " + ex.Message + "\n" + ex.StackTrace);
                AHOBPRLogger.LogErrorMessage("Exception", this.GetType().Name + "." + System.Reflection.MethodBase.GetCurrentMethod().Name, ex.StackTrace);
            }
            return response;
        }
        
      
     

       
    }
}
